<?php namespace App\Controllers\Api\Manager\Projects;

use App\Controllers\PrivateController;
use App\Libraries\AppSubscription;
use App\Libraries\Common;
use App\Models\AppsModel;
use CodeIgniter\HTTP\ResponseInterface;

class ProjectDetail extends PrivateController
{
    /**************************************************************************************
     * PUBLIC FUNCTIONS
     **************************************************************************************/

    /**
     * Get short app detail
     * @return ResponseInterface
     */
    public function index(): ResponseInterface
    {
        $uid = esc($this->request->getGet("uid"));

        $projects = new AppsModel();

        $app = $projects
            ->where("uid", $uid)
            ->where("deleted_at", 0)
            ->select("uid,name,link,id,user")
            ->first();

        if (!$app) {
            return $this->respond(["message" => lang("Message.message_14")], 404);
        }

        $appSubscription = new AppSubscription($app["id"]);
        $subscription = $appSubscription->get_active_subscription();

        $common = new Common();

        return $this->respond([
            "name"      => $app["name"],
            "link"      => $app["link"],
            "icon"      => $common->get_icon($app["uid"]),
            "subscribe" => $subscription !== null,
            "subscribe_date" => $subscription && $subscription["type"] == "subscription" ? date('d-m-Y H:i', $subscription['expires_at']) : "",
            "user_id"   => (int) $app["user"]
        ], 200);
    }

}